/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class GravebladeMarauderEffect
extends OneShotEffect {
    GravebladeMarauderEffect() {
        super(Outcome.LoseLife);
        this.staticText = "that player loses life equal to the number of creature cards in your graveyard";
    }

    private GravebladeMarauderEffect(GravebladeMarauderEffect effect) {
        super((OneShotEffect)effect);
    }

    public GravebladeMarauderEffect copy() {
        return new GravebladeMarauderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (targetPlayer != null && controller != null) {
            targetPlayer.loseLife(controller.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game), game, source, false);
            return true;
        }
        return false;
    }
}

