/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;

class GravecrawlerPlayEffect
extends AsThoughEffectImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("zombie");

    public GravecrawlerPlayEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfGame, Outcome.Benefit);
        this.staticText = "You may cast this card from your graveyard as long as you control a Zombie";
    }

    private GravecrawlerPlayEffect(GravecrawlerPlayEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public GravecrawlerPlayEffect copy() {
        return new GravecrawlerPlayEffect(this);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        Card card;
        return sourceId.equals(source.getSourceId()) && source.isControlledBy(affectedControllerId) && (card = game.getCard(source.getSourceId())) != null && game.getState().getZone(source.getSourceId()) == Zone.GRAVEYARD && game.getBattlefield().countAll((FilterPermanent)filter, source.getControllerId(), game) > 0;
    }

    static {
        filter.add((Predicate)SubType.ZOMBIE.getPredicate());
    }
}

