/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.EncoreAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;

class GraywatersFixerEffect
extends ContinuousEffectImpl {
    GraywatersFixerEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "each outlaw creature card in your graveyard has encore {X}, where X is its mana value";
    }

    private GraywatersFixerEffect(GraywatersFixerEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (Card card : controller.getGraveyard().getCards(game)) {
            if (!card.isCreature(game) || !card.isOutlaw(game)) continue;
            EncoreAbility ability = new EncoreAbility((Cost)new GenericManaCost(card.getManaValue()));
            ability.setSourceId(card.getId());
            ability.setControllerId(card.getOwnerId());
            game.getState().addOtherAbility(card, (Ability)ability);
        }
        return true;
    }

    public GraywatersFixerEffect copy() {
        return new GraywatersFixerEffect(this);
    }
}

