/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.TreasureToken;

class GreatTrainHeistTriggeredAbility
extends DelayedTriggeredAbility {
    private final UUID playerId;

    GreatTrainHeistTriggeredAbility(UUID playerId) {
        super((Effect)new CreateTokenEffect((Token)new TreasureToken(), 1, true), Duration.EndOfTurn, false, false);
        this.setTriggerPhrase("Whenever a creature you control deals combat damage to that player this turn, ");
        this.playerId = playerId;
    }

    private GreatTrainHeistTriggeredAbility(GreatTrainHeistTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.playerId = ability.playerId;
    }

    public GreatTrainHeistTriggeredAbility copy() {
        return new GreatTrainHeistTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!((DamagedPlayerEvent)event).isCombatDamage() || !event.getTargetId().equals(this.playerId)) {
            return false;
        }
        Permanent permanent = game.getPermanent(event.getSourceId());
        return permanent != null && permanent.isCreature(game) && permanent.isControlledBy(this.getControllerId());
    }
}

