/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.ActivatedAbility;
import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.RemoveCounterSourceEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;

class GreaterGargadonAbility
extends ActivatedAbilityImpl {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("artifact, creature, or land");

    public GreaterGargadonAbility() {
        super(Zone.EXILED, (Effect)new RemoveCounterSourceEffect(CounterType.TIME.createInstance()), (Cost)new SacrificeTargetCost((FilterPermanent)filter));
    }

    private GreaterGargadonAbility(GreaterGargadonAbility ability) {
        super((ActivatedAbilityImpl)ability);
    }

    public GreaterGargadonAbility copy() {
        return new GreaterGargadonAbility(this);
    }

    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        Card card = game.getCard(this.getSourceId());
        if (card == null || card.getCounters(game).getCount(CounterType.TIME) == 0) {
            return ActivatedAbility.ActivationStatus.getFalse();
        }
        return super.canActivate(playerId, game);
    }

    public String getRule() {
        return super.getRule() + " Activate only if {this} is suspended.";
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.LAND.getPredicate()}));
    }
}

