/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.costs.common.PayEnergyCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public final class GreenbeltRampager
extends CardImpl {
    public GreenbeltRampager(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{G}");
        this.subtype.add((Object)SubType.ELEPHANT);
        this.power = new MageInt(3);
        this.toughness = new MageInt(4);
        this.addAbility((Ability)new EntersBattlefieldTriggeredAbility((Effect)new GreenbeltRampagerEffect(), false));
    }

    private GreenbeltRampager(GreenbeltRampager card) {
        super((CardImpl)card);
    }

    public GreenbeltRampager copy() {
        return new GreenbeltRampager(this);
    }

    private static class GreenbeltRampagerEffect
    extends OneShotEffect {
        GreenbeltRampagerEffect() {
            super(Outcome.Neutral);
            this.staticText = "pay {E}{E}. If you can't, return {this} to its owner's hand and you get {E}";
        }

        private GreenbeltRampagerEffect(GreenbeltRampagerEffect effect) {
            super((OneShotEffect)effect);
        }

        public boolean apply(Game game, Ability source) {
            Permanent sourceObject;
            Player controller = game.getPlayer(source.getControllerId());
            if (controller == null) {
                return false;
            }
            if (!new PayEnergyCost(2).pay(source, game, source, source.getControllerId(), true) && (sourceObject = source.getSourcePermanentIfItStillExists(game)) != null) {
                controller.moveCards((Card)sourceObject, Zone.HAND, source, game);
                controller.addCounters(CounterType.ENERGY.createInstance(), source.getControllerId(), source, game);
            }
            return true;
        }

        public GreenbeltRampagerEffect copy() {
            return new GreenbeltRampagerEffect(this);
        }
    }
}

