/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GremlinMineEffect
extends OneShotEffect {
    GremlinMineEffect() {
        super(Outcome.Detriment);
        this.staticText = "Remove up to four charge counters from target noncreature artifact";
    }

    private GremlinMineEffect(GremlinMineEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (player != null && permanent != null) {
            int existingCount = permanent.getCounters(game).getCount(CounterType.CHARGE);
            if (existingCount > 0) {
                ChoiceImpl choice = new ChoiceImpl(false);
                choice.setMessage("Select number of charge counters to remove:");
                Integer i = 0;
                while (i <= existingCount) {
                    choice.getChoices().add(i.toString());
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
                if (player.choose(Outcome.Detriment, (Choice)choice, game)) {
                    permanent.removeCounters(CounterType.CHARGE.getName(), Integer.parseInt(choice.getChoice()), source, game);
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public GremlinMineEffect copy() {
        return new GremlinMineEffect(this);
    }
}

