/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.g.GrenzoHavocRaiserEffect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetadjustment.DefineByTriggerTargetAdjuster;
import mage.target.targetadjustment.TargetAdjuster;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GrenzoHavocRaiserTriggeredAbility
extends TriggeredAbilityImpl {
    String damagedPlayerName = null;

    public GrenzoHavocRaiserTriggeredAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect, false);
        this.setTriggerPhrase("Whenever a creature you control deals combat damage to a player, ");
        this.setTargetAdjuster((TargetAdjuster)DefineByTriggerTargetAdjuster.instance);
    }

    private GrenzoHavocRaiserTriggeredAbility(GrenzoHavocRaiserTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
        this.damagedPlayerName = ability.damagedPlayerName;
    }

    public GrenzoHavocRaiserTriggeredAbility copy() {
        return new GrenzoHavocRaiserTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        this.damagedPlayerName = null;
        ((Effect)this.getEffects().get(0)).setText("goad target creature that player controls");
        Player damagedPlayer = game.getPlayer(event.getPlayerId());
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        Permanent abilitySourcePermanent = this.getSourcePermanentIfItStillExists(game);
        if (damagedPlayer == null || permanent == null || abilitySourcePermanent == null) {
            return false;
        }
        if (((DamagedEvent)event).isCombatDamage() && this.isControlledBy(permanent.getControllerId())) {
            this.damagedPlayerName = damagedPlayer.getLogName();
            ((Effect)this.getEffects().get(0)).setText("goad target creature that player controls (" + this.damagedPlayerName + ")");
            game.informPlayers(abilitySourcePermanent.getLogName() + " triggered for damaged " + this.damagedPlayerName);
            FilterCreaturePermanent filter = new FilterCreaturePermanent("creature " + damagedPlayer.getLogName() + " controls");
            filter.add((Predicate)new ControllerIdPredicate(damagedPlayer.getId()));
            this.getTargets().clear();
            this.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
            for (Effect effect : this.getAllEffects()) {
                if (!(effect instanceof GrenzoHavocRaiserEffect)) continue;
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
                effect.setValue("damage", (Object)event.getAmount());
            }
            return true;
        }
        return false;
    }
}

