/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class GrevenPredatorCaptainEffect
extends OneShotEffect {
    GrevenPredatorCaptainEffect() {
        super(Outcome.Benefit);
        this.staticText = "sacrifice another creature. If you do, you draw cards equal to that creature's power and you lose life equal to that creature's toughness.";
    }

    private GrevenPredatorCaptainEffect(GrevenPredatorCaptainEffect effect) {
        super((OneShotEffect)effect);
    }

    public GrevenPredatorCaptainEffect copy() {
        return new GrevenPredatorCaptainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, 1, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_ANOTHER_CREATURE, true);
        if (!player.choose(this.outcome, (Target)target, source, game)) {
            return false;
        }
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        int power = permanent.getPower().getValue();
        int toughness = permanent.getToughness().getValue();
        if (!permanent.sacrifice(source, game)) {
            return false;
        }
        player.drawCards(power, source, game);
        player.loseLife(toughness, game, source, false);
        return true;
    }
}

