/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.g.GrimeGorgerTarget;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class GrimeGorgerEffect
extends OneShotEffect {
    GrimeGorgerEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to one card of each card type from defending player's graveyard. Put a +1/+1 counter on {this} for each card exiled this way";
    }

    private GrimeGorgerEffect(GrimeGorgerEffect effect) {
        super((OneShotEffect)effect);
    }

    public GrimeGorgerEffect copy() {
        return new GrimeGorgerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        UUID defenderId = this.getTargetPointer().getFirst(game, source);
        if (player == null || defenderId == null) {
            return false;
        }
        GrimeGorgerTarget target = new GrimeGorgerTarget(defenderId);
        player.choose(this.outcome, (Target)target, source, game);
        CardsImpl cards = new CardsImpl((Collection)target.getTargets());
        if (cards.isEmpty()) {
            return false;
        }
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.retainZone(Zone.EXILED, game);
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent != null) {
            permanent.addCounters(CounterType.P1P1.createInstance(cards.size()), source, game);
        }
        return true;
    }
}

