/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.g.GrimoireOfTheDeadEffect2;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class GrimoireOfTheDeadEffect
extends OneShotEffect {
    GrimoireOfTheDeadEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Put all creature cards from all graveyards onto the battlefield under your control. They're black Zombies in addition to their other colors and types";
    }

    private GrimoireOfTheDeadEffect(GrimoireOfTheDeadEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        LinkedHashSet creatureCards = new LinkedHashSet();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            creatureCards.addAll(player.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game));
        }
        controller.moveCards(creatureCards, Zone.BATTLEFIELD, source, game);
        List permanents = creatureCards.stream().map(c -> CardUtil.getPermanentFromCardPutToBattlefield((Card)c, (Game)game)).filter(Objects::nonNull).collect(Collectors.toList());
        game.addEffect(new GrimoireOfTheDeadEffect2().setTargetPointer((TargetPointer)new FixedTargets(permanents, game)), source);
        return true;
    }

    public GrimoireOfTheDeadEffect copy() {
        return new GrimoireOfTheDeadEffect(this);
    }
}

