/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GrimoireOfTheDeadEffect2
extends ContinuousEffectImpl {
    GrimoireOfTheDeadEffect2() {
        super(Duration.Custom, Outcome.Neutral);
    }

    private GrimoireOfTheDeadEffect2(GrimoireOfTheDeadEffect2 effect) {
        super((ContinuousEffectImpl)effect);
    }

    public GrimoireOfTheDeadEffect2 copy() {
        return new GrimoireOfTheDeadEffect2(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        for (UUID permanentId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null) continue;
            switch (layer) {
                case ColorChangingEffects_5: {
                    permanent.getColor(game).setBlack(true);
                    break;
                }
                case TypeChangingEffects_4: {
                    permanent.addSubType(game, new SubType[]{SubType.ZOMBIE});
                }
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.ColorChangingEffects_5 || layer == Layer.TypeChangingEffects_4;
    }
}

