/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;

class GrimoireThiefLookEffect
extends AsThoughEffectImpl {
    GrimoireThiefLookEffect() {
        super(AsThoughEffectType.LOOK_AT_FACE_DOWN, Duration.EndOfGame, Outcome.Benefit);
        this.staticText = "You may look at cards exiled with {this}";
    }

    private GrimoireThiefLookEffect(GrimoireThiefLookEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public GrimoireThiefLookEffect copy() {
        return new GrimoireThiefLookEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (affectedControllerId.equals(source.getControllerId()) && game.getState().getZone(objectId) == Zone.EXILED) {
            Set exileZones;
            Card card;
            Player controller = game.getPlayer(source.getControllerId());
            MageObject sourceObject = source.getSourceObject(game);
            if (controller != null && sourceObject != null && (card = game.getCard(objectId)) != null && card.isFaceDown(game) && (exileZones = (Set)game.getState().getValue("ExileZones" + source.getSourceId().toString())) != null) {
                for (ExileZone exileZone : game.getExile().getExileZones()) {
                    if (!exileZone.contains((Object)objectId) || exileZones.contains(exileZone.getId())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

