/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.MillCardsTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GrislySpectacleEffect
extends OneShotEffect {
    GrislySpectacleEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Its controller mills cards equal to that creature's power";
    }

    private GrislySpectacleEffect(GrislySpectacleEffect effect) {
        super((OneShotEffect)effect);
    }

    public GrislySpectacleEffect copy() {
        return new GrislySpectacleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        Permanent creature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (creature != null && (controller = game.getPlayer(creature.getControllerId())) != null) {
            int power = creature.getPower().getValue();
            MillCardsTargetEffect effect = new MillCardsTargetEffect(power);
            effect.setTargetPointer((TargetPointer)new FixedTarget(controller.getId()));
            return effect.apply(game, source);
        }
        return false;
    }
}

