/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.common.EntersBattlefieldThisOrAnotherTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.abilities.effects.common.ExileAndReturnSourceEffect;
import mage.constants.Pronoun;
import mage.constants.PutCards;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;

class GristVoraciousLarvaTriggeredAbility
extends EntersBattlefieldThisOrAnotherTriggeredAbility {
    GristVoraciousLarvaTriggeredAbility() {
        super((Effect)new DoIfCostPaid((Effect)new ExileAndReturnSourceEffect(PutCards.BATTLEFIELD_TRANSFORMED, Pronoun.IT), (Cost)new ManaCostsImpl("{G}")), (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, false, true);
        this.setTriggerPhrase("Whenever {this} or another creature you control enters, if it entered from your graveyard or you cast it from your graveyard, ");
    }

    private GristVoraciousLarvaTriggeredAbility(GristVoraciousLarvaTriggeredAbility ability) {
        super((EntersBattlefieldThisOrAnotherTriggeredAbility)ability);
    }

    public GristVoraciousLarvaTriggeredAbility copy() {
        return new GristVoraciousLarvaTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell;
        EntersTheBattlefieldEvent zEvent = (EntersTheBattlefieldEvent)event;
        if (zEvent == null) {
            return false;
        }
        Permanent permanent = zEvent.getTarget();
        if (permanent == null) {
            return false;
        }
        Zone fromZone = zEvent.getFromZone();
        boolean fromGraveyard = false;
        if (fromZone == Zone.GRAVEYARD) {
            fromGraveyard = true;
        } else if (fromZone == Zone.STACK && (spell = game.getSpellOrLKIStack(permanent.getId())) != null && spell.getFromZone() == Zone.GRAVEYARD) {
            fromGraveyard = true;
        }
        return fromGraveyard && super.checkTrigger(event, game);
    }
}

