/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.common.LimitedTimesPerTurnActivatedAbility;
import mage.abilities.condition.common.OpponentControlsPermanentCondition;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.Effects;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Duration;
import mage.constants.EffectType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;

class GroundlingPouncerAbility
extends LimitedTimesPerTurnActivatedAbility {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();
    private static final Effects emptyEffects;
    private static final String ruleText = "{G/U}: {this} gets +1/+3 and gains flying until end of turn. Activate only once each turn and only if an opponent controls a creature with flying.";

    GroundlingPouncerAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BoostSourceEffect(1, 3, Duration.EndOfTurn), (Cost)new ManaCostsImpl("{G/U}"));
        this.condition = new OpponentControlsPermanentCondition((FilterPermanent)filter);
        this.addEffect((Effect)new GainAbilitySourceEffect((Ability)FlyingAbility.getInstance(), Duration.EndOfTurn));
    }

    private GroundlingPouncerAbility(GroundlingPouncerAbility ability) {
        super((LimitedTimesPerTurnActivatedAbility)ability);
    }

    public Effects getEffects(Game game, EffectType effectType) {
        if (!this.condition.apply(game, (Ability)this)) {
            return emptyEffects;
        }
        return super.getEffects(game, effectType);
    }

    public GroundlingPouncerAbility copy() {
        return new GroundlingPouncerAbility(this);
    }

    public String getRule() {
        return ruleText;
    }

    static {
        filter.add((Predicate)new AbilityPredicate(FlyingAbility.class));
        emptyEffects = new Effects(new Effect[0]);
    }
}

