/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class GrudgeKeeperEffect
extends OneShotEffect {
    GrudgeKeeperEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent who voted for a choice you didn't vote for loses 2 life";
    }

    private GrudgeKeeperEffect(GrudgeKeeperEffect effect) {
        super((OneShotEffect)effect);
    }

    public GrudgeKeeperEffect copy() {
        return new GrudgeKeeperEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Set playerIds = (Set)this.getValue("votedAgainst");
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player player;
            if (!playerIds.contains(opponentId) || (player = game.getPlayer(opponentId)) == null) continue;
            player.loseLife(2, game, source, false);
        }
        return true;
    }
}

