/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class GruesomeMenagerieEffect
extends OneShotEffect {
    private static final FilterCard filter1 = new FilterCreatureCard("creature card with mana value 1");
    private static final FilterCard filter2 = new FilterCreatureCard("creature card with mana value 2");
    private static final FilterCard filter3 = new FilterCreatureCard("creature card with mana value 3");

    public GruesomeMenagerieEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose a creature card with mana value 1 in your graveyard, then do the same for creature cards with mana value 2 and 3. Return those cards to the battlefield.";
    }

    private GruesomeMenagerieEffect(GruesomeMenagerieEffect effect) {
        super((OneShotEffect)effect);
    }

    public GruesomeMenagerieEffect copy() {
        return new GruesomeMenagerieEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(filter1);
        target.withNotTarget(true);
        if (player.choose(this.outcome, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            cards.add(card);
        }
        target = new TargetCardInYourGraveyard(filter2);
        target.withNotTarget(true);
        if (player.choose(this.outcome, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            cards.add(card);
        }
        target = new TargetCardInYourGraveyard(filter3);
        target.withNotTarget(true);
        if (player.choose(this.outcome, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            cards.add(card);
        }
        return player.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
    }

    static {
        filter1.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, 1));
        filter2.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, 2));
        filter3.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, 3));
    }
}

