/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.effects.common.continuous.LoseAbilitySourceEffect;
import mage.abilities.keyword.DefenderAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class GuardianOfTheAgesTriggerAbility
extends TriggeredAbilityImpl {
    private static final FilterCard filter = new FilterCard("creature");

    public GuardianOfTheAgesTriggerAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GainAbilitySourceEffect((Ability)TrampleAbility.getInstance()));
        this.addEffect((Effect)new LoseAbilitySourceEffect((Ability)DefenderAbility.getInstance()));
    }

    private GuardianOfTheAgesTriggerAbility(GuardianOfTheAgesTriggerAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent creature = game.getPermanent(event.getSourceId());
        return creature != null && filter.match((Card)creature, game) && game.getOpponents(this.getControllerId()).contains(creature.getControllerId()) && game.getPermanent(this.getSourceId()).getAbilities().contains((Ability)DefenderAbility.getInstance());
    }

    public String getRule() {
        return "When a creature attacks you or a planeswalker you control, if {this} has defender, it loses defender and gains trample.";
    }

    public GuardianOfTheAgesTriggerAbility copy() {
        return new GuardianOfTheAgesTriggerAbility(this);
    }

    static {
        filter.add(Predicates.and((Predicate[])new Predicate[]{CardType.CREATURE.getPredicate()}));
    }
}

