/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldAllTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.g.GuardianProjectEffect;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.filter.predicate.mageobject.CardIdPredicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GuardianProjectTriggeredAbility
extends EntersBattlefieldAllTriggeredAbility {
    GuardianProjectTriggeredAbility() {
        super((Effect)new GuardianProjectEffect(null), (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE_NON_TOKEN);
    }

    private GuardianProjectTriggeredAbility(GuardianProjectTriggeredAbility ability) {
        super((EntersBattlefieldAllTriggeredAbility)ability);
    }

    public GuardianProjectTriggeredAbility copy() {
        return new GuardianProjectTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = ((EntersTheBattlefieldEvent)event).getTarget();
        if (permanent == null || !this.filter.match(permanent, this.controllerId, (Ability)this, game)) {
            return false;
        }
        if (GuardianProjectTriggeredAbility.checkCondition(permanent, this.controllerId, game)) {
            this.getEffects().clear();
            this.addEffect((Effect)new GuardianProjectEffect(new MageObjectReference((MageObject)permanent, game)));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a nontoken creature you control enters, if it doesn't have the same name as another creature you control or a creature card in your graveyard, draw a card.";
    }

    static boolean checkCondition(Permanent permanent, UUID controllerId, Game game) {
        Player player = game.getPlayer(controllerId);
        if (player == null) {
            return false;
        }
        if (!permanent.getName().isEmpty()) {
            FilterCard filterCard = new FilterCard();
            filterCard.add((Predicate)new NamePredicate(permanent.getName()));
            filterCard.add((Predicate)new OwnerIdPredicate(controllerId));
            if (player.getGraveyard().count(filterCard, game) > 0) {
                return false;
            }
        }
        FilterCreaturePermanent filterPermanent = new FilterCreaturePermanent();
        filterPermanent.add((Predicate)new NamePredicate(permanent.getName()));
        filterPermanent.add(Predicates.not((Predicate)new CardIdPredicate(permanent.getId())));
        filterPermanent.add((Predicate)new ControllerIdPredicate(controllerId));
        return game.getBattlefield().getActivePermanents((FilterPermanent)filterPermanent, controllerId, game).isEmpty();
    }
}

