/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetOpponent;

class GuidedPassageEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("noncreature, nonland card");

    GuidedPassageEffect() {
        super(Outcome.Benefit);
        this.staticText = "Reveal the cards in your library. An opponent chooses from among them a creature card, a land card, and a noncreature, nonland card. You put the chosen cards into your hand. Then shuffle.";
    }

    private GuidedPassageEffect(GuidedPassageEffect effect) {
        super((OneShotEffect)effect);
    }

    public GuidedPassageEffect copy() {
        return new GuidedPassageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller == null || sourceObject == null) {
            return false;
        }
        int libSize = controller.getLibrary().size();
        if (libSize == 0) {
            controller.shuffleLibrary(source, game);
            return true;
        }
        CardsImpl cards = new CardsImpl();
        cards.addAllCards((Collection)controller.getLibrary().getTopCards(game, libSize));
        controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
        Set opponents = game.getOpponents(controller.getId());
        if (opponents.size() == 1) {
            opponent = game.getPlayer((UUID)opponents.iterator().next());
        } else {
            TargetOpponent target = new TargetOpponent(true);
            controller.chooseTarget(Outcome.Detriment, (Target)target, source, game);
            opponent = game.getPlayer(target.getFirstTarget());
        }
        TargetCard target1 = new TargetCard(1, Zone.LIBRARY, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        TargetCard target2 = new TargetCard(1, Zone.LIBRARY, (FilterCard)StaticFilters.FILTER_CARD_LAND);
        TargetCard target3 = new TargetCard(1, Zone.LIBRARY, filter);
        opponent.chooseTarget(Outcome.Detriment, (Cards)cards, target1, source, game);
        opponent.chooseTarget(Outcome.Detriment, (Cards)cards, target2, source, game);
        opponent.chooseTarget(Outcome.Detriment, (Cards)cards, target3, source, game);
        CardsImpl cardsToHand = new CardsImpl();
        Card cardToHand = game.getCard(target1.getFirstTarget());
        if (cardToHand != null) {
            cardsToHand.add(cardToHand);
        }
        if ((cardToHand = game.getCard(target2.getFirstTarget())) != null) {
            cardsToHand.add(cardToHand);
        }
        if ((cardToHand = game.getCard(target3.getFirstTarget())) != null) {
            cardsToHand.add(cardToHand);
        }
        controller.moveCards((Cards)cardsToHand, Zone.HAND, source, game);
        controller.shuffleLibrary(source, game);
        return true;
    }

    static {
        filter.add(Predicates.not((Predicate)CardType.CREATURE.getPredicate()));
        filter.add(Predicates.not((Predicate)CardType.LAND.getPredicate()));
    }
}

