/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;

class GuileReplacementEffect
extends ReplacementEffectImpl {
    GuileReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Exile);
        this.staticText = "If a spell or ability you control would counter a spell, instead exile that spell and you may play that card without paying its mana cost";
    }

    private GuileReplacementEffect(GuileReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public GuileReplacementEffect copy() {
        return new GuileReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Spell spell = game.getStack().getSpell(event.getTargetId());
        Player controller = game.getPlayer(source.getControllerId());
        if (spell != null && controller != null) {
            controller.moveCards((Card)spell, Zone.EXILED, source, game);
            if (!spell.isCopy()) {
                Card spellCard = spell.getCard();
                if (spellCard != null && controller.chooseUse(Outcome.PlayForFree, "Play " + spellCard.getIdName() + " for free?", source, game)) {
                    controller.playCard(spellCard, game, true, new ApprovingObject(source, game));
                }
                return true;
            }
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Spell counteredSpell = game.getStack().getSpell(event.getTargetId());
        StackObject counteringObject = game.getStack().getStackObject(event.getSourceId());
        return counteredSpell != null && counteringObject != null && counteringObject.isControlledBy(source.getControllerId());
    }
}

