/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.g.GusthasScepterLookAtCardEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class GusthasScepterExileEffect
extends OneShotEffect {
    GusthasScepterExileEffect() {
        super(Outcome.DrawCard);
        this.staticText = "exile a card from your hand face down. You may look at it for as long as it remains exiled";
    }

    private GusthasScepterExileEffect(GusthasScepterExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || controller.getHand().isEmpty()) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand();
        controller.chooseTarget(this.outcome, controller.getHand(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        controller.moveCardsToExile(card, source, game, false, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        card.setFaceDown(true, game);
        game.addEffect((ContinuousEffect)new GusthasScepterLookAtCardEffect(card, game), source);
        return true;
    }

    public GusthasScepterExileEffect copy() {
        return new GusthasScepterExileEffect(this);
    }
}

