/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.cards.g.GutterGrimeEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;

class GutterGrimeTriggeredAbility
extends TriggeredAbilityImpl {
    public GutterGrimeTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.SLIME.createInstance()), false);
        this.addEffect((Effect)new GutterGrimeEffect());
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private GutterGrimeTriggeredAbility(GutterGrimeTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public GutterGrimeTriggeredAbility copy() {
        return new GutterGrimeTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        UUID targetId = event.getTargetId();
        MageObject card = game.getLastKnownInformation(targetId, Zone.BATTLEFIELD);
        if (card instanceof Permanent && !(card instanceof PermanentToken)) {
            Permanent permanent = (Permanent)card;
            ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
            return zEvent.isDiesEvent() && permanent.isControlledBy(this.controllerId) && (targetId.equals(this.getSourceId()) || permanent.isCreature(game));
        }
        return false;
    }

    public String getRule() {
        return "Whenever a nontoken creature you control dies, put a slime counter on {this}, then create a green Ooze creature token with \"This creature's power and toughness are each equal to the number of slime counters on {this}.\"";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

