/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Collection;
import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class GwenomRemorselessPlayTopCardEffect
extends AsThoughEffectImpl {
    GwenomRemorselessPlayTopCardEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfTurn, Outcome.AIDontUseIt);
        this.staticText = "you may play cards from the top of your library. If you cast a spell this way, pay life equal to its mana value rather than pay its mana cost.";
    }

    private GwenomRemorselessPlayTopCardEffect(GwenomRemorselessPlayTopCardEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public GwenomRemorselessPlayTopCardEffect copy() {
        return new GwenomRemorselessPlayTopCardEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Card cardToCheck = game.getCard(objectId);
        if (cardToCheck == null) {
            return false;
        }
        if (!affectedControllerId.equals(source.getControllerId())) {
            return false;
        }
        Player player = game.getPlayer(cardToCheck.getOwnerId());
        if (player == null || !player.getId().equals(affectedControllerId)) {
            return false;
        }
        Card topCard = player.getLibrary().getFromTop(game);
        if (topCard == null || !topCard.getId().equals(cardToCheck.getMainCard().getId())) {
            return false;
        }
        if (!cardToCheck.isLand(game)) {
            PayLifeCost lifeCost = new PayLifeCost(cardToCheck.getSpellAbility().getManaCosts().manaValue());
            CostsImpl newCosts = new CostsImpl();
            newCosts.add((Object)lifeCost);
            newCosts.addAll((Collection)cardToCheck.getSpellAbility().getCosts());
            player.setCastSourceIdWithAlternateMana(cardToCheck.getId(), null, (Costs)newCosts, MageIdentifier.GwenomRemorselessAlternateCast);
        }
        return true;
    }
}

