/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValueParityPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class GyrudaDoomOfDepthsEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCreatureCard("creature card with an even mana value");

    GyrudaDoomOfDepthsEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player mills four cards. Put a creature card with an even mana value from among the milled cards onto the battlefield under your control";
    }

    private GyrudaDoomOfDepthsEffect(GyrudaDoomOfDepthsEffect effect) {
        super((OneShotEffect)effect);
    }

    public GyrudaDoomOfDepthsEffect copy() {
        return new GyrudaDoomOfDepthsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            cards.addAll((Collection)player.millCards(4, source, game));
        }
        if (cards.isEmpty()) {
            return true;
        }
        TargetCard targetCard = new TargetCard(0, 1, Zone.ALL, filter);
        targetCard.withNotTarget(true);
        controller.choose(this.outcome, (Cards)cards, targetCard, source, game);
        Card card = game.getCard(targetCard.getFirstTarget());
        return card != null && controller.moveCards(card, Zone.BATTLEFIELD, source, game);
    }

    static {
        filter.add((Predicate)ManaValueParityPredicate.EVEN);
    }
}

