/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RickSteadfastLeaderGainEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.HUMAN);

    RickSteadfastLeaderGainEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.Benefit);
        this.staticText = "Humans you control have each of the chosen abilities";
    }

    private RickSteadfastLeaderGainEffect(RickSteadfastLeaderGainEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public RickSteadfastLeaderGainEffect copy() {
        return new RickSteadfastLeaderGainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Object choice = game.getState().getValue(source.getSourceId() + "_rick");
        if (!(choice instanceof String)) {
            return false;
        }
        FirstStrikeAbility ability1 = null;
        VigilanceAbility ability2 = null;
        switch ((String)choice) {
            case "First strike and vigilance": {
                ability1 = FirstStrikeAbility.getInstance();
                ability2 = VigilanceAbility.getInstance();
                break;
            }
            case "First strike and lifelink": {
                ability1 = FirstStrikeAbility.getInstance();
                ability2 = LifelinkAbility.getInstance();
                break;
            }
            case "Vigilance and lifelink": {
                ability1 = VigilanceAbility.getInstance();
                ability2 = LifelinkAbility.getInstance();
                break;
            }
            default: {
                return false;
            }
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            if (permanent == null) continue;
            permanent.addAbility((Ability)ability1, source.getSourceId(), game);
            permanent.addAbility((Ability)ability2, source.getSourceId(), game);
        }
        return true;
    }
}

