/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.watchers.common.PermanentsEnteredBattlefieldWatcher;

enum GoblinsEnteredThisTurnDynamicValue implements DynamicValue
{
    instance;


    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        List permanents;
        int goblins = 0;
        PermanentsEnteredBattlefieldWatcher watcher = (PermanentsEnteredBattlefieldWatcher)game.getState().getWatcher(PermanentsEnteredBattlefieldWatcher.class);
        if (watcher != null && (permanents = watcher.getThisTurnEnteringPermanents(sourceAbility.getControllerId())) != null) {
            for (Permanent permanent : permanents) {
                if (!permanent.hasSubtype(SubType.GOBLIN, game)) continue;
                ++goblins;
            }
        }
        return goblins;
    }

    public GoblinsEnteredThisTurnDynamicValue copy() {
        return instance;
    }

    public String toString() {
        return "1";
    }

    public String getMessage() {
        return "Goblins that entered the battlefield under your control this turn";
    }
}

