/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class HakbalOfTheSurgingSoulEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("a land card");

    public HakbalOfTheSurgingSoulEffect() {
        super(Outcome.DrawCard);
        this.staticText = "you may put a land card from your hand onto the battlefield. If you don't, draw a card";
    }

    private HakbalOfTheSurgingSoulEffect(HakbalOfTheSurgingSoulEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            if (player.chooseUse(Outcome.PutCardInPlay, "Put " + filter.getMessage() + " from your hand onto the battlefield?", source, game)) {
                Card card;
                TargetCardInHand target = new TargetCardInHand(filter);
                if (player.choose(Outcome.PutCardInPlay, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
                    return player.moveCards(card, Zone.BATTLEFIELD, source, game, false, false, false, null);
                }
            } else {
                player.drawCards(1, source, game);
            }
            return true;
        }
        return false;
    }

    public HakbalOfTheSurgingSoulEffect copy() {
        return new HakbalOfTheSurgingSoulEffect(this);
    }

    static {
        filter.add((Predicate)CardType.LAND.getPredicate());
    }
}

