/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.watchers.Watcher;

class HallOfTheBanditLordWatcher
extends Watcher {
    private final List<UUID> creatures = new ArrayList<UUID>();

    HallOfTheBanditLordWatcher() {
        super(WatcherScope.CARD);
    }

    public void watch(GameEvent event, Game game) {
        ZoneChangeEvent zEvent;
        if (event.getType() == GameEvent.EventType.MANA_PAID) {
            MageObject target = game.getObject(event.getTargetId());
            if (event.getSourceId() != null && event.getSourceId().equals(this.getSourceId()) && target != null && target.isCreature(game) && event.getFlag() && target instanceof Spell) {
                this.creatures.add(((Spell)target).getCard().getId());
            }
        }
        if (event.getType() == GameEvent.EventType.COUNTERED && this.creatures.contains(event.getTargetId())) {
            this.creatures.remove(event.getSourceId());
        }
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && this.creatures.contains(event.getSourceId()) && (zEvent = (ZoneChangeEvent)event).getToZone() == Zone.STACK) {
            this.creatures.remove(event.getSourceId());
        }
        if (event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD && this.creatures.contains(event.getSourceId())) {
            GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.Custom);
            effect.setTargetPointer((TargetPointer)new FixedTarget(event.getSourceId(), game));
            SpellAbility source = game.getPermanent(event.getSourceId()).getSpellAbility();
            game.addEffect((ContinuousEffect)effect, (Ability)source);
            this.creatures.remove(event.getSourceId());
        }
    }

    public void reset() {
        super.reset();
        this.creatures.clear();
    }
}

