/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.MayCastTargetCardEffect;
import mage.constants.CastManaAdjustment;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

class HaloForagerPayEffect
extends OneShotEffect {
    HaloForagerPayEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may pay {X}. When you do, you may cast target instant or sorcery card with mana value X from a graveyard without paying its mana cost. If that spell would be put into a graveyard, exile it instead.";
    }

    private HaloForagerPayEffect(HaloForagerPayEffect effect) {
        super((OneShotEffect)effect);
    }

    public HaloForagerPayEffect copy() {
        return new HaloForagerPayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        ManaCostsImpl cost = new ManaCostsImpl("{X}");
        if (player == null || !player.chooseUse(this.outcome, "Pay " + cost.getText() + "?", source, game)) {
            return false;
        }
        int costX = player.announceX(0, Integer.MAX_VALUE, "Announce the value for {X} (pay to free cast)", game, source, true);
        cost.add((Object)new GenericManaCost(costX));
        if (!cost.pay(source, game, source, source.getControllerId(), false, null)) {
            return false;
        }
        FilterInstantOrSorceryCard filter = new FilterInstantOrSorceryCard("instant or sorcery card with mana value " + costX + " from a graveyard");
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, costX));
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new MayCastTargetCardEffect(CastManaAdjustment.WITHOUT_PAYING_MANA_COST, true), false);
        ability.addTarget((Target)new TargetCardInGraveyard((FilterCard)filter));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

