/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.NumberOfTriggersEvent;

class HamaPasharRuinSeekerEffect
extends ReplacementEffectImpl {
    HamaPasharRuinSeekerEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "room abilities of dungeons you own trigger an additional time";
    }

    private HamaPasharRuinSeekerEffect(HamaPasharRuinSeekerEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public HamaPasharRuinSeekerEffect copy() {
        return new HamaPasharRuinSeekerEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        GameEvent gameEvent = ((NumberOfTriggersEvent)event).getSourceEvent();
        return gameEvent != null && gameEvent.getType() == GameEvent.EventType.ROOM_ENTERED && source.isControlledBy(gameEvent.getPlayerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(event.getAmount() + 1);
        return false;
    }
}

