/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HammerOfNazahnEffect
extends OneShotEffect {
    HammerOfNazahnEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may attach that Equipment to target creature you control";
    }

    private HammerOfNazahnEffect(HammerOfNazahnEffect effect) {
        super((OneShotEffect)effect);
    }

    public HammerOfNazahnEffect copy() {
        return new HammerOfNazahnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent equipment = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            Permanent targetCreature = game.getPermanent(source.getTargets().getFirstTarget());
            if (equipment != null && targetCreature != null) {
                targetCreature.addAttachment(equipment.getId(), source, game);
            }
            return true;
        }
        return false;
    }
}

