/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Optional;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.events.GameEvent;

class HandToHandEffect
extends ContinuousRuleModifyingEffectImpl {
    HandToHandEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "During combat, players can't cast instant spells or activate abilities that aren't mana abilities";
    }

    private HandToHandEffect(HandToHandEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public HandToHandEffect copy() {
        return new HandToHandEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "During combat, players can't cast instant spells or activate abilities that aren't mana abilities (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL || event.getType() == GameEvent.EventType.ACTIVATE_ABILITY;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (game.getTurnPhaseType() == TurnPhase.COMBAT) {
            MageObject object = game.getObject(event.getSourceId());
            if (event.getType() == GameEvent.EventType.CAST_SPELL && object != null && object.isInstant(game)) {
                return true;
            }
            if (event.getType() == GameEvent.EventType.ACTIVATE_ABILITY) {
                Optional ability = game.getAbility(event.getTargetId(), event.getSourceId());
                return ability.isPresent() && !((Ability)ability.get()).isManaActivatedAbility();
            }
        }
        return false;
    }
}

