/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.UseAttachedCost;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class HankyuCost
extends UseAttachedCost {
    private int removedCounters = 0;

    HankyuCost() {
    }

    private HankyuCost(HankyuCost cost) {
        super((UseAttachedCost)cost);
        this.removedCounters = cost.removedCounters;
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        if (this.mageObjectReference == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return this.paid;
        }
        for (UUID attachmentId : permanent.getAttachments()) {
            Permanent equipment;
            if (!this.mageObjectReference.refersTo(attachmentId, game) || (equipment = this.mageObjectReference.getPermanent(game)) == null) continue;
            this.removedCounters = equipment.removeAllCounters(CounterType.AIM.getName(), source, game);
            this.paid = true;
            break;
        }
        return this.paid;
    }

    public HankyuCost copy() {
        return new HankyuCost(this);
    }

    public String getText() {
        return "remove all aim counters from " + this.name;
    }

    public int getRemovedCounters() {
        return this.removedCounters;
    }
}

