/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.effects.Effect;
import mage.abilities.triggers.BeginningOfEndStepTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.h.HaphazardBombardmentEffect;
import mage.cards.h.HaphazardBombardmentEndOfTurnEffect;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.TargetController;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;

public final class HaphazardBombardment
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent("if two or more permanents you don't control have an aim counter on them");
    private static final Condition condition;

    public HaphazardBombardment(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{5}{R}");
        this.addAbility((Ability)new EntersBattlefieldTriggeredAbility((Effect)new HaphazardBombardmentEffect(), false));
        this.addAbility((Ability)new BeginningOfEndStepTriggeredAbility((Effect)new HaphazardBombardmentEndOfTurnEffect()).withInterveningIf(condition));
    }

    private HaphazardBombardment(HaphazardBombardment card) {
        super((CardImpl)card);
    }

    public HaphazardBombardment copy() {
        return new HaphazardBombardment(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.NOT_YOU.getControllerPredicate());
        filter.add((Predicate)CounterType.AIM.getPredicate());
        condition = new PermanentsOnTheBattlefieldCondition(filter, ComparisonType.MORE_THAN, 1);
    }
}

