/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class HaphazardBombardmentEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("nonenchantment permanents you don't control");

    HaphazardBombardmentEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose four nonenchantment permanents you don't control and put an aim counter on each of them";
    }

    private HaphazardBombardmentEffect(HaphazardBombardmentEffect effect) {
        super((OneShotEffect)effect);
    }

    public HaphazardBombardmentEffect copy() {
        return new HaphazardBombardmentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        List permanents = game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game);
        if (permanents.size() > 4) {
            permanents.clear();
            TargetPermanent target = new TargetPermanent(4, 4, filter, true);
            controller.chooseTarget(this.outcome, (Target)target, source, game);
            permanents.addAll(target.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        for (Permanent permanent : permanents) {
            permanent.addCounters(CounterType.AIM.createInstance(), source.getControllerId(), source, game);
        }
        return true;
    }

    static {
        filter.add(Predicates.not((Predicate)CardType.ENCHANTMENT.getPredicate()));
        filter.add((ObjectSourcePlayerPredicate)TargetController.NOT_YOU.getControllerPredicate());
    }
}

