/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterEnchantmentPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HarmonicConvergenceEffect
extends OneShotEffect {
    HarmonicConvergenceEffect() {
        super(Outcome.Neutral);
        this.staticText = "Put all enchantments on top of their owners' libraries";
    }

    private HarmonicConvergenceEffect(HarmonicConvergenceEffect effect) {
        super((OneShotEffect)effect);
    }

    public HarmonicConvergenceEffect copy() {
        return new HarmonicConvergenceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            FilterEnchantmentPermanent filter = new FilterEnchantmentPermanent();
            filter.add((Predicate)new OwnerIdPredicate(player.getId()));
            CardsImpl toLib = new CardsImpl();
            for (Permanent enchantment : game.getBattlefield().getActivePermanents((FilterPermanent)filter, playerId, source, game)) {
                toLib.add((Card)enchantment);
            }
            player.putCardsOnTopOfLibrary((Cards)toLib, game, source, true);
        }
        return true;
    }
}

