/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.target.TargetPlayer;

class HarshJudgmentEffect
extends RedirectionEffect {
    private static final FilterInstantOrSorceryCard instantOrSorceryFilter = new FilterInstantOrSorceryCard();

    public HarshJudgmentEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "If an instant or sorcery spell of the chosen color would deal damage to you, it deals that damage to its controller instead";
    }

    private HarshJudgmentEffect(HarshJudgmentEffect effect) {
        super((RedirectionEffect)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getTargetId().equals(source.getControllerId())) {
            Spell spell = null;
            StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
            if (stackObject == null) {
                stackObject = (StackObject)game.getLastKnownInformation(event.getSourceId(), Zone.STACK);
            }
            if (stackObject instanceof Spell) {
                spell = (Spell)stackObject;
            }
            Permanent permanent = game.getPermanent(source.getSourceId());
            ObjectColor color = (ObjectColor)game.getState().getValue(permanent.getId() + "_color");
            if (spell != null && instantOrSorceryFilter.match(spell.getCard(), game) && spell.getColor(game).contains(color)) {
                TargetPlayer target = new TargetPlayer();
                target.add(spell.getControllerId(), game);
                this.redirectTarget = target;
                return true;
            }
        }
        return false;
    }

    public HarshJudgmentEffect copy() {
        return new HarshJudgmentEffect(this);
    }
}

