/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HarshJusticeEffect
extends OneShotEffect {
    HarshJusticeEffect() {
        super(Outcome.Benefit);
        this.staticText = "it deals that much damage to its controller";
    }

    private HarshJusticeEffect(HarshJusticeEffect effect) {
        super((OneShotEffect)effect);
    }

    public HarshJusticeEffect copy() {
        return new HarshJusticeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        Permanent targetObject;
        int damage = (Integer)this.getValue("damage");
        UUID sourceId = (UUID)this.getValue("sourceId");
        MageObject sourceObject = game.getObject(source);
        if (sourceObject != null && damage > 0 && sourceId != null && (targetObject = game.getPermanentOrLKIBattlefield(sourceId)) != null && (controller = game.getPlayer(targetObject.getControllerId())) != null) {
            game.informPlayers(sourceObject.getLogName() + ": " + targetObject.getLogName() + " deals " + damage + " damage to " + controller.getLogName());
            controller.damage(damage, sourceId, source, game);
            return true;
        }
        return false;
    }
}

