/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.h.HarshJusticeEffect;
import mage.constants.Duration;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.AttackingPredicate;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HarshJusticeTriggeredAbility
extends DelayedTriggeredAbility {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("attacking creature");

    public HarshJusticeTriggeredAbility() {
        super((Effect)new HarshJusticeEffect(), Duration.EndOfTurn, false);
        this.setTriggerPhrase("This turn, whenever an attacking creature deals combat damage to you, ");
    }

    private HarshJusticeTriggeredAbility(HarshJusticeTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public HarshJusticeTriggeredAbility copy() {
        return new HarshJusticeTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player controller = game.getPlayer(this.getControllerId());
        DamagedPlayerEvent damageEvent = (DamagedPlayerEvent)event;
        Permanent damagePermanent = game.getPermanentOrLKIBattlefield(damageEvent.getSourceId());
        if (controller != null && damagePermanent != null && damageEvent.isCombatDamage() && controller.getId().equals(damageEvent.getTargetId()) && filter.match((Object)damagePermanent, game)) {
            for (Effect effect : this.getEffects()) {
                effect.setValue("damage", (Object)damageEvent.getAmount());
                effect.setValue("sourceId", (Object)damageEvent.getSourceId());
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)AttackingPredicate.instance);
    }
}

