/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackAbility;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HarshMentorTriggeredAbility
extends TriggeredAbilityImpl {
    HarshMentorTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect((DynamicValue)StaticValue.get((int)2), true, "that player", true));
    }

    private HarshMentorTriggeredAbility(HarshMentorTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public HarshMentorTriggeredAbility copy() {
        return new HarshMentorTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        StackAbility stackAbility;
        Permanent source;
        if (!event.getPlayerId().equals(this.getControllerId()) && (source = game.getPermanentOrLKIBattlefield(event.getSourceId())) != null && (source.isArtifact(game) || source.isCreature(game) || source.isLand(game)) && !(stackAbility = (StackAbility)game.getStack().getStackObject(event.getSourceId())).getStackAbility().isManaActivatedAbility()) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever an opponent activates an ability of an artifact, creature, or land on the battlefield, if it isn't a mana ability, {this} deals 2 damage to that player.";
    }
}

