/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class HarvestHandReturnTransformedEffect
extends OneShotEffect {
    HarvestHandReturnTransformedEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "return it to the battlefield transformed under your control";
    }

    private HarvestHandReturnTransformedEffect(HarvestHandReturnTransformedEffect effect) {
        super((OneShotEffect)effect);
    }

    public HarvestHandReturnTransformedEffect copy() {
        return new HarvestHandReturnTransformedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = source.getSourceCardIfItStillExists(game);
        if (controller == null || card == null) {
            return false;
        }
        game.getState().setValue("EnterTransformed" + source.getSourceId(), (Object)Boolean.TRUE);
        controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        return true;
    }
}

