/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class HarvestSeasonEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("tapped creature you control");

    HarvestSeasonEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search your library for up to X basic land cards, where X is the number of tapped creatures you control, put those cards onto the battlefield tapped, then shuffle.";
    }

    private HarvestSeasonEffect(HarvestSeasonEffect effect) {
        super((OneShotEffect)effect);
    }

    public HarvestSeasonEffect copy() {
        return new HarvestSeasonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            TargetCardInLibrary target;
            int tappedCreatures = new PermanentsOnBattlefieldCount(filter).calculate(game, source, (Effect)this);
            if (tappedCreatures > 0 && controller.searchLibrary(target = new TargetCardInLibrary(0, tappedCreatures, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND), source, game)) {
                controller.moveCards(new CardsImpl((Collection)target.getTargets()).getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)TappedPredicate.TAPPED);
    }
}

