/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.RevealLibraryPickControllerEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.PutCards;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;

class HatcherySpiderEffect
extends OneShotEffect {
    HatcherySpiderEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "reveal the top X cards of your library, where X is the number of creature cards in your graveyard. You may put a green permanent card with mana value X or less from among them onto the battlefield. Put the rest on the bottom of your library in a random order.";
    }

    private HatcherySpiderEffect(HatcherySpiderEffect effect) {
        super((OneShotEffect)effect);
    }

    public HatcherySpiderEffect copy() {
        return new HatcherySpiderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int xValue = player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game);
        FilterPermanentCard filter = new FilterPermanentCard("green permanent card with mana value " + xValue + " or less");
        filter.add((Predicate)new ColorPredicate(ObjectColor.GREEN));
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, xValue + 1));
        return new RevealLibraryPickControllerEffect(xValue, 1, (FilterCard)filter, PutCards.BATTLEFIELD, PutCards.BOTTOM_RANDOM).apply(game, source);
    }
}

