/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;

class HaukensInsightLookEffect
extends AsThoughEffectImpl {
    private final UUID authorizedPlayerId;

    public HaukensInsightLookEffect(UUID authorizedPlayerId) {
        super(AsThoughEffectType.LOOK_AT_FACE_DOWN, Duration.EndOfGame, Outcome.Benefit);
        this.authorizedPlayerId = authorizedPlayerId;
    }

    private HaukensInsightLookEffect(HaukensInsightLookEffect effect) {
        super((AsThoughEffectImpl)effect);
        this.authorizedPlayerId = effect.authorizedPlayerId;
    }

    public HaukensInsightLookEffect copy() {
        return new HaukensInsightLookEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        UUID cardId = this.getTargetPointer().getFirst(game, source);
        if (cardId == null) {
            this.discard();
        }
        return affectedControllerId.equals(this.authorizedPlayerId) && objectId.equals(cardId);
    }
}

