/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackAbility;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HauntingWindTriggeredAbility
extends TriggeredAbilityImpl {
    HauntingWindTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(1));
    }

    private HauntingWindTriggeredAbility(HauntingWindTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public HauntingWindTriggeredAbility copy() {
        return new HauntingWindTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY || event.getType() == GameEvent.EventType.TAPPED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.ACTIVATED_ABILITY) {
            Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
            if (permanent == null || !permanent.isArtifact(game)) {
                return false;
            }
            StackAbility stackAbility = (StackAbility)game.getStack().getStackObject(event.getSourceId());
            if (stackAbility == null) {
                return false;
            }
            String abilityText = stackAbility.getRule(true);
            if (abilityText.contains("{T}:") || abilityText.contains("{T},") || abilityText.contains("{T} or")) {
                return false;
            }
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent.getControllerId(), game));
            }
            return true;
        }
        if (event.getType() == GameEvent.EventType.TAPPED) {
            Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
            if (permanent == null || !permanent.isArtifact(game)) {
                return false;
            }
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent.getControllerId(), game));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever an artifact becomes tapped or a player activates an artifact's ability without {T} in its activation cost, {this} deals 1 damage to that artifact's controller.";
    }
}

