/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Objects;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.EachTargetPointer;
import mage.target.targetpointer.TargetPointer;

class HavocEaterEffect
extends OneShotEffect {
    HavocEaterEffect() {
        super(Outcome.Benefit);
        this.staticText = "put X +1/+1 counters on {this}, where X is the total power of creatures goaded this way";
        this.setTargetPointer((TargetPointer)new EachTargetPointer());
    }

    private HavocEaterEffect(HavocEaterEffect effect) {
        super((OneShotEffect)effect);
    }

    public HavocEaterEffect copy() {
        return new HavocEaterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        int amount = this.getTargetPointer().getTargets(game, source).stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).map(MageObject::getPower).mapToInt(MageInt::getValue).sum();
        return amount > 0 && permanent.addCounters(CounterType.P1P1.createInstance(amount), source, game);
    }
}

