/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class HealingTechniqueEffect
extends OneShotEffect {
    HealingTechniqueEffect() {
        super(Outcome.Benefit);
        this.staticText = "return target card from your graveyard to your hand. You gain life equal to that card's mana value";
    }

    private HealingTechniqueEffect(HealingTechniqueEffect effect) {
        super((OneShotEffect)effect);
    }

    public HealingTechniqueEffect copy() {
        return new HealingTechniqueEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (player == null || card == null) {
            return false;
        }
        int manaValue = card.getManaValue();
        player.moveCards(card, Zone.HAND, source, game);
        player.gainLife(manaValue, game, source);
        return true;
    }
}

