/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class HeartlessHidetsuguDamageEffect
extends OneShotEffect {
    HeartlessHidetsuguDamageEffect() {
        super(Outcome.Detriment);
        this.staticText = "{this} deals damage to each player equal to half that player's life total, rounded down";
    }

    private HeartlessHidetsuguDamageEffect(HeartlessHidetsuguDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public HeartlessHidetsuguDamageEffect copy() {
        return new HeartlessHidetsuguDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                int damage = player.getLife() / 2;
                player.damage(damage, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

